% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCE_methods.R
\name{organism.sce}
\alias{organism.sce}
\alias{organism,SingleCellExperiment-method}
\alias{organism}
\alias{organism<-,SingleCellExperiment-method}
\title{Get or set \code{organism} from a SingleCellExperiment object}
\usage{
organism.sce(object)

\S4method{organism}{SingleCellExperiment}(object)

\S4method{organism}{SingleCellExperiment}(object) <- value
}
\arguments{
\item{object}{A \code{\link{SingleCellExperiment}} object.}

\item{value}{Value to be assigned to corresponding object.}
}
\value{
organism string
}
\description{
Get or set \code{organism} from a SingleCellExperiment object
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication

organism(sce)

}
\author{
Luyi Tian
}
