% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bAccuracy.R
\name{bAccuracy}
\alias{bAccuracy}
\title{bAccuracy}
\usage{
bAccuracy(cls.truth, final)
}
\arguments{
\item{cls.truth}{A character vector of true class label.}

\item{final}{A vector of final classified label prediction from
\code{multiAdaSampling}.}
}
\value{
An accuracy value.
}
\description{
This function calculates the accuracy of the prediction to the true label.
}
\examples{
data("gse87795_subset_sce")

mat.expr <- gse87795_subset_sce
cellTypes <- gse87795_subset_sce$cellTypes

# Get dimension reduced matrix. We are using `logNorm` assay from `mat.expr`.
mat.pc <- matPCs(mat.expr, assay = "logNorm")

# Here we are using Support Vector Machine as a base classifier.
result <- multiAdaSampling(mat.pc, cellTypes, classifier = "svm",
percent = 1, L = 10)

final <- result$final

# Balanced accuracy
bacc <- bAccuracy(cellTypes, final)

}
\author{
Pengyi Yang, Taiyun Kim
}
