% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalAbundance.R
\name{clonalAbundance}
\alias{clonalAbundance}
\title{Plot the Relative Abundance of Clones}
\usage{
clonalAbundance(
  input.data,
  cloneCall = "strict",
  chain = "both",
  scale = FALSE,
  group.by = NULL,
  order.by = NULL,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}},
\code{\link[=combineBCR]{combineBCR()}}, or \code{\link[=combineExpression]{combineExpression()}}.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL},
\code{IGK}, \code{Light} (for both light chains), or \code{both} (for TRA/B and Heavy/Light).}

\item{scale}{Converts the graphs into density plots in order to show
relative distributions.}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}.}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing clonal abundance by group, or a
data.frame if \code{exportTable = TRUE}.
}
\description{
Displays the number of clones at specific frequencies by sample
or group. Visualization can either be a line graph (
\code{scale} = FALSE) using calculated numbers or density
plot (\code{scale} = TRUE). Multiple sequencing runs can
be group together using the group parameter. If a matrix
output for the data is preferred, set
\code{exportTable} = TRUE.
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Using clonalAbundance()
clonalAbundance(combined, 
                cloneCall = "gene", 
                scale = FALSE)

}
\author{
Nick Borcherding, Justin Reimertz
}
\concept{Visualizing_Clones}
