% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportClones.R
\name{exportClones}
\alias{exportClones}
\title{Export Clonal Data in Various Formats}
\usage{
exportClones(
  input.data,
  format = "paired",
  group.by = NULL,
  write.file = TRUE,
  dir = NULL,
  file.name = "clones.csv"
)
}
\arguments{
\item{input.data}{The product of \code{combineTCR()}, \code{combineBCR()}, or
\code{combineExpression()}.}

\item{format}{The format for exporting clones.
Options are: \code{paired}, \code{airr}, \code{TCRMatch}, \code{tcrpheno}, \code{immunarch}.}

\item{group.by}{The variable in the metadata to use for grouping. If \code{NULL},
data will be grouped by the sample names.}

\item{write.file}{If \code{TRUE} (default), saves the output to a CSV file. If
\code{FALSE}, returns the data frame or list to the R environment.}

\item{dir}{The directory where the output file will be saved.
Defaults to the current working directory.}

\item{file.name}{The name of the file to be saved.}
}
\value{
A data frame or list in the specified format, either returned to the
R environment or saved as a CSV file.
}
\description{
Exports clonal information (gene sequences, amino acids, nucleotides) from
scRepertoire objects into a file or a data frame. The output format can be
tailored for compatibility with different analysis workflows.
}
\details{
The \code{format} parameter determines the structure of the output:
\itemize{
\item{\code{paired}}: Exports a data frame where each row represents a barcode,
with paired chain information (amino acid, nucleotide, genes) in separate
columns.
\item{\code{airr}}: Exports a data frame that adheres to the Adaptive Immune
Receptor Repertoire (AIRR) Community format, with each row representing
a single receptor chain.
\item{\code{TCRMatch}}: Exports a data frame specifically for the TCRMatch
algorithm, containing the TRB chain amino acid sequence and clonal
frequency.
\item{\code{tcrpheno}}: Exports a data frame compatible with the \code{tcrpheno}
pipeline, with TRA and TRB chains in separate columns.
\item{\code{immunarch}}: Exports a list containing a data frame and metadata
formatted for use with the \code{immunarch} package.
}
}
\examples{
\dontrun{
#Making combined contig data
combined <- combineTCR(contig_list,
                       samples = c("P17B", "P17L", "P18B", "P18L",
                                   "P19B", "P19L", "P20B", "P20L"))

# Export as a paired data frame and save to a file
exportClones(combined, format = "paired", file.name = "paired_clones.csv")

# Return an AIRR-formatted data frame to the environment
airr_df <- exportClones(combined, format = "airr", write.file = FALSE)
}
}
\author{
Jonathan Noonan, Nick Borcherding
}
\concept{Loading_and_Processing_Contigs}
