% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KdModels.R
\name{assignKdType}
\alias{assignKdType}
\title{assignKdType}
\usage{
assignKdType(x, mod, mer8 = NULL)
}
\arguments{
\item{x}{A vector of matched sequences, each of 12 nucleotides}

\item{mod}{An object of class `KdModel`}

\item{mer8}{The optional set of 8mers included in the model (for internal
use; can be reconstructed from the model).}
}
\value{
A data.frame with one row for each element of `x`, and the columns
`type` and `log_kd`. To save space, the reported log_kd is multiplied by
1000, rounded and saved as an integer.
}
\description{
Assigns a log_kd and match type to a set of matched sequences.
}
\examples{
data(SampleKdModel)
assignKdType(c("CTAGCATTAAGT","ACGTACGTACGT"), SampleKdModel)
}
