% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanning.R
\name{get3pAlignment}
\alias{get3pAlignment}
\title{Finds 3' complementary binding of a miRNA}
\usage{
get3pAlignment(
  seqs,
  mirseq,
  mir3p.start = 9L,
  allow.mismatch = TRUE,
  maxMirLoop = 7L,
  maxTargetLoop = 9L,
  maxLoopDiff = 4L,
  TGsub = TRUE,
  siteType = NULL
)
}
\arguments{
\item{seqs}{A set of sequences in which to look for 3' matches (i.e. upstream
of the seed match)}

\item{mirseq}{The sequence of the mature miRNA}

\item{mir3p.start}{The position in `mirseq` in which to start looking}

\item{allow.mismatch}{Logical; whether to allow mismatches}

\item{maxMirLoop}{Maximum miRNA loop size}

\item{maxTargetLoop}{Maximum target loop size}

\item{maxLoopDiff}{Maximum size difference between miRNA and target loops}

\item{TGsub}{Logical; whether to allow T/G substitutions.}

\item{siteType}{The optional type of seed-complementarity, as returned by
\code{\link{getMatchTypes}}. This is needed to identify slicing/TDMD sites.
If given, should be a vector of the same length as `seqs`.}
}
\value{
A data.frame with one row for each element of `seqs`, indicating the
size of the miRNA bulge, the size of the target mRNA bulge, the number of
mismatches at the 3' end, and the partial 3' alignment score (i.e. roughly
the number of consecutive matching nucleotides)
}
\description{
Performs a local alignment of the miRNA 3' sequence (determined by
`mir3p.start`) on given the given sequences.
}
\examples{
get3pAlignment(seqs="NNAGTGTGCCATNN", mirseq="TGGAGTGTGACAATGGTGTTTG")
}
