% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postSelRegion.R
\name{postSelRegion}
\alias{postSelRegion}
\title{Merge sel_region from the selectRegion function to SpatialExperiment.}
\usage{
postSelRegion(spe, sel_region)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{sel_region}{A dataframe object. Can be generated from
function selectRegion.}
}
\value{
A SpatialExperiment object.
}
\description{
Merge sel_region from the selectRegion function to SpatialExperiment.
}
\examples{

data("xenium_bc_spe")

coi <- c("Breast cancer", "Fibroblasts", "B cells", "T cells")

spe <- gridDensity(spe, coi = coi)

sel_region <- data.frame(
    "node" = seq(10),
    "node_x" = seq(10),
    "node_y" = seq(10)
)

spe1 <- postSelRegion(spe, sel_region)

}
