% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcs_plot.R
\name{fcs_plot}
\alias{fcs_plot}
\title{Plot flow data from index sorted cells}
\usage{
fcs_plot(processed_fcs_list = NULL)
}
\arguments{
\item{processed_fcs_list}{List generated using `fcs_processing()` containing two data.frames}
}
\value{
Returns a ggplot object with a traditional flow density plot with the sorted cells and the selected thresholds for the two probes used in fcs_processing().
}
\description{
Plot a traditional flow density plot with the sorted cells and the selected 
thresholds for the two probes used in `fcs_processing()`.
}
\examples{
index_sort_data <- fcs_processing(
    folder_path = system.file("/extdata/fcs_index_sorting",
        package = "scifer"
    ),
    compensation = TRUE, plate_wells = 96,
    probe1 = "Pre.F", probe2 = "Post.F",
    posvalue_probe1 = 600, posvalue_probe2 = 400
)

fcs_plot_obj <- fcs_plot(index_sort_data)

}
