% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secondary_peaks.R
\name{secondary_peaks}
\alias{secondary_peaks}
\title{Check for secondary peaks in a sangerseq object}
\usage{
secondary_peaks(
  s,
  ratio = 0.33,
  output.folder = NA,
  file.prefix = "seq",
  processors = NULL
)
}
\arguments{
\item{s}{a sangerseq s4 object from the sangerseqR package}

\item{ratio}{Ratio of the height of a secondary peak to a primary peak. Secondary peaks higher than this ratio are annotated. Those below the ratio are not.}

\item{output.folder}{If output.folder is NA (the default) no files are written. If a valid folder is provided, two files are written to that folder: a .csv file of the secondary peaks (see description below) and a .pdf file of the chromatogram.}

\item{file.prefix}{If output.folder is specified, this is the prefix which will be appended to the .csv and the .pdf file. The default is "seq".}

\item{processors}{Number of processors to use, or NULL (the default) for all available processors}
}
\value{
A list with two elements:
         \enumerate{
             \item {secondary.peaks}: a data frame with one row per secondary peak above the ratio, and three columns: "position" is the position of the secondary peak relative to the primary sequence; "primary.basecall" is the primary base call; "secondary.basecall" is the secondary basecall. \cr
             \item {read}: the input sangerseq s4 object after having the makeBaseCalls() function from sangerseqR applied to it. This re-calls the primary and secondary bases in the sequence, and resets a lot of the internal data.
         }
}
\description{
This function finds and reports secondary peaks in a sangerseq object.
It returns a table of secondary peaks, and optionally saves an annotated 
chromatogram and a csv file of the peak locations.
}
\examples{
## Read abif using sangerseqR package
s4_sangerseq <- sangerseqR::readsangerseq(
    system.file("/extdata/sorted_sangerseq/E18_C1/A1_3_IgG_Inner.ab1",
        package = "scifer"
    )
)

## Summarise using summarise_abi_file()
processed_seq <- scifer:::secondary_peaks(s4_sangerseq)

}
