% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpgDiscretization.R
\name{cpgDiscretization}
\alias{cpgDiscretization}
\title{Discretize the CpG methylation values
to align with single cell analysis}
\usage{
cpgDiscretization(bs, subSample = 1e+06, offset = 50000,
  coverageVec = NULL)
}
\arguments{
\item{bs}{bsseq object}

\item{subSample}{number of CpGs to subsample.
Default value is 1000000.}

\item{offset}{how many CpGs to offset when subsampling
Default value is set to be 50000, i.e. first 50000 CpGs will
be ignored in subsampling.}

\item{coverageVec}{If coverage vector is already calculated provide it to
speed up the process}
}
\value{
meth discretized methylation matrix

discard total number of removed CpGs from each sample

Percentage of CpGs discarded compared to the total number of CpGs
}
\description{
In single cell analysis overwhelmingly large number of CpGs have binary
methylation
Due to errors in sequencing and amplification many CpGs tend to have
non-binary methylation. Hence
this function catergorizes the non-binary CpGs as methylated if the
methyation is above 0.8 and
unmethylated if the methylation is below 0.2
}
\examples{
directory <- system.file("extdata/bismark_data", package='scmeth')
bs <- HDF5Array::loadHDF5SummarizedExperiment(directory)
cpgDiscretization(bs)
}
