% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{biplot_color}
\alias{biplot_color}
\title{Function for biplotting with no point labels and with
points color-coded according to a quantitative variable.
For example: the rank of normalization performance.}
\usage{
biplot_color(
  x,
  y,
  rank = TRUE,
  ties_method = c("max", "min", "first", "last", "random"),
  choices = 1:2,
  expand = 1,
  ...
)
}
\arguments{
\item{x}{\code{\link[stats]{prcomp}} object.}

\item{y}{numeric. Quantitative values used to color the points. If rank is 
FALSE, all values must be positive integers and less than or equal to the 
length of y.}

\item{rank}{logical. If TRUE (default) y will be transformed by the rank() 
function}

\item{ties_method}{character. ties.method used by the rank() function}

\item{choices}{numeric. 2 principal components to plot. Default to first two
PCs.}

\item{expand}{numeric. value used to adjust the spread of the arrows
relative to the points.}

\item{...}{arguments passed to plot.}
}
\value{
Invisibly returns scaled point coordinates used in plot.
}
\description{
This function implements biplot for \code{\link[stats]{prcomp}} objects.
}
\examples{
mat <- matrix(rnorm(1000), ncol=10)
colnames(mat) <- paste("X", 1:ncol(mat), sep="")

pc <- prcomp(mat)

biplot_color(pc, rank(pc$x[,1]))

}
