% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/get_design.R
\name{get_design}
\alias{get_design}
\alias{get_design,SconeExperiment,character-method}
\alias{get_design,SconeExperiment,numeric-method}
\title{Retrieve Design Matrix}
\usage{
get_design(x, method)

\S4method{get_design}{SconeExperiment,character}(x, method)

\S4method{get_design}{SconeExperiment,numeric}(x, method)
}
\arguments{
\item{x}{a \code{\link{SconeExperiment}} object containing the results of
\code{\link{scone}}.}

\item{method}{character or numeric. Either a string identifying the
normalization scheme to be retrieved, or a numeric index with the rank of
the normalization method to retrieve (according to scone ranking of
normalizations).}
}
\value{
The design matrix.
}
\description{
Given a \code{SconeExperiment} object created by a call to scone, it will
return the design matrix of the selected method.
}
\details{
The numeric method will always return the design matrix 
  corresponding to row \code{method} of the \code{scone_params} 
  slot. This means that if \code{\link{scone}} was run with 
  \code{eval=TRUE}, \code{get_design(x, 1)} will return the top
  ranked method. If \code{\link{scone}} was run with 
  \code{eval=FALSE}, \code{get_design(x, 1)} will return the first
  normalization in the order saved by scone.
}
\section{Functions}{
\itemize{
\item \code{get_design(x = SconeExperiment, method = character)}: If 
\code{method} is a character, it will return the design
matrix corresponding to the normalization scheme specified
by the character string. The string must be one of the
\code{row.names} of the slot \code{scone_params}.

\item \code{get_design(x = SconeExperiment, method = numeric)}: If
\code{method} is a numeric, it will return the design matrix
according to the scone ranking.

}}
\examples{
set.seed(42)
mat <- matrix(rpois(500, lambda = 5), ncol=10)
colnames(mat) <- paste("X", 1:ncol(mat), sep="")
obj <- SconeExperiment(mat, bio = factor(rep(c(1,2),each = 5)),
           batch = factor(rep(c(1,2),times = 5)))
res <- scone(obj, scaling=list(none=identity, uq=UQ_FN),
           evaluate=TRUE, k_ruv=0, k_qc=0,
           adjust_batch = "yes", adjust_bio = "yes",
           eval_kclust=2, bpparam = BiocParallel::SerialParam())
design_top = get_design(res,1)

}
