% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_clusterKmeans.R
\name{clusterKmeans.se}
\alias{clusterKmeans.se}
\title{k-means clustering of cells in a SingleCellExperiment}
\usage{
clusterKmeans.se(
  x,
  k,
  num.threads = 1,
  more.kmeans.args = list(),
  reddim.type = "PCA",
  output.name = "clusters",
  meta.name = NULL
)
}
\arguments{
\item{x}{A \link[SingleCellExperiment]{SingleCellExperiment} object or one of its subclasses.
Rows correspond to genomic features and columns correspond to cells.}

\item{k}{Number of clusters, passed to \code{\link{clusterKmeans}}.}

\item{num.threads}{Number of threads, passed to \code{\link{clusterKmeans}}.}

\item{more.kmeans.args}{Named list of further arguments to be passed to \code{\link{clusterKmeans}}.}

\item{reddim.type}{Integer or string specifying the existing embedding in the \code{\link[SingleCellExperiment]{reducedDim}} of \code{x}.
Alternatively, a named integer or character vector of length 1,
where the name specifies an alternative experiment of \code{x} and the value is the name/index of a \code{reducedDim} entry in that alternative experiment.}

\item{output.name}{String containing the name of the \code{\link[SummarizedExperiment]{colData}} column in which to store the cluster assignments.}

\item{meta.name}{String containing the name of the \code{\link[S4Vectors]{metadata}} entry in which to store extra clustering output.
If \code{NULL}, no extra clustering output is stored.}
}
\value{
\code{x} is returned with the cluster assignment for each cell stored in the \code{colData}.
Additional clustering output is stored in the \code{metadata}.
}
\description{
Perform k-means clustering on an existing low-dimensional embedding
by calling \code{\link{clusterKmeans}} on a reduced dimension entry in a \link[SingleCellExperiment]{SingleCellExperiment}.
}
\examples{
sce <- getTestRnaData.se("pca")
sce <- clusterKmeans.se(sce, k=10)
table(sce$clusters)

}
\author{
Aaron Lun
}
