% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countGroupsByBlock.R
\name{countGroupsByBlock}
\alias{countGroupsByBlock}
\title{Count cells in groups and blocks}
\usage{
countGroupsByBlock(
  groups,
  block,
  normalize.block = FALSE,
  normalize.groups = FALSE
)
}
\arguments{
\item{groups}{Factor specifying the group to which each cell was assigned.
This is typically used for clusters.}

\item{block}{Factor specifying the block to which each cell was assigned.
This is typically used for batches or samples.}

\item{normalize.block}{Boolean indicating whether to normalize the number of cells across blocks.
If \code{TRUE}, frequencies are divided by the column sums.}

\item{normalize.groups}{Boolean indicating whether to normalize the number of cells across groups.
If \code{TRUE}, frequencies are divided by the row sums.
This is performed after normalization of the block counts if \code{normalize.block=TRUE}.}
}
\value{
Matrix of (normalized) frequencies.
Each row corresponds to a group and each column corresponds to a block.
}
\description{
Tabulate the frequency of cells in each combination of groups and blocks.
This is typically used to examine the distribution of cells across batches for each cluster -
the presence of a batch-specific cluster may be indicative of a batch effect.
}
\examples{
groups <- sample(10, 100, replace=TRUE)
block <- sample(LETTERS[1:6], 100, replace=TRUE)

countGroupsByBlock(groups, block)
countGroupsByBlock(groups, block, normalize.block=TRUE)
countGroupsByBlock(groups, block, normalize.groups=TRUE)
countGroupsByBlock(groups, block, normalize.block=TRUE, normalize.groups=TRUE)

}
\seealso{
\code{\link{table}}, which is used internally by this function.
}
\author{
Aaron Lun
}
