% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_xfplate.R
\name{sketch_rate}
\alias{sketch_rate}
\title{Generate a plot for the rate data}
\usage{
sketch_rate(
  xf_rate,
  param = "OCR",
  normalize = FALSE,
  normalize_unit = "10000 cells",
  take_group_mean = TRUE,
  reorder_legend = FALSE
)
}
\arguments{
\item{xf_rate}{The `rate_data` tibble as generated by `revive_plate`}

\item{param}{Either "OCR" or "ECAR"}

\item{normalize}{Either TRUE or FALSE}

\item{normalize_unit}{any string that will be pasted in the y-axis label
when normalize = TRUE}

\item{take_group_mean}{Either TRUE or FALSE}

\item{reorder_legend}{Either TRUE or FALSE. When `TRUE` the
groups are ordered based on the number in the character string of
the group. It also adds a "__00" after each character string
to make the forcats::refactor(group, parse_number(group)) work.}
}
\value{
a ggplot object
}
\description{
The sketch_rate() function uses the rate_data
from the generated output from the revive_xfplate() function.
The injection info is annotated in the plot, using the information
form the injections provided in the original experiment. Several
options are available to plot either ECAR/OCR or normalize the
data with the values from the normalization cells in the .xlsx file.

A number of validations are performed to check whether the data
can be plotted and whether the layout of the plot will not be
ruined...
}
\examples{
system.file("extdata",
    "20191219_SciRep_PBMCs_donor_A.xlsx",
    package = "seahtrue"
) |>
    revive_xfplate() |>
    purrr::pluck("rate_data", 1) |>
    sketch_rate(
        param = "OCR",
        reorder_legend = TRUE
    )

system.file("extdata",
    "20191219_SciRep_PBMCs_donor_A.xlsx",
    package = "seahtrue"
) |>
    revive_xfplate() |>
    purrr::pluck("rate_data", 1) |>
    sketch_rate(
        param = "OCR",
        take_group_mean = FALSE,
        reorder_legend = TRUE
    )

system.file("extdata",
    "20191219_SciRep_PBMCs_donor_A.xlsx",
    package = "seahtrue"
) |>
    revive_xfplate() |>
    purrr::pluck("rate_data", 1) |>
    sketch_rate(
        param = "ECAR",
        normalize = TRUE,
        take_group_mean = TRUE,
        reorder_legend = TRUE
    )

system.file("extdata",
    "20191219_SciRep_PBMCs_donor_A.xlsx",
    package = "seahtrue"
) |>
    revive_xfplate() |>
    purrr::pluck("rate_data", 1) |>
    sketch_rate(
        param = "ECAR",
        normalize = TRUE,
        take_group_mean = FALSE,
        reorder_legend = TRUE
    )
}
