% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fit.norm}
\alias{fit.norm}
\title{Internal function}
\usage{
fit.norm(y, z, it.em, epsilon)
}
\arguments{
\item{y}{\strong{observations:}
numeric vector of length \code{n}}

\item{z}{\strong{class labels:}
integer vector of length \code{n},
with entries \code{0}, \code{1} and \code{NA}}

\item{it.em}{(maximum) number of iterations in the \code{EM} algorithm\strong{:}
positive integer (defaults to \code{100})}

\item{epsilon}{convergence criterion for the \code{EM} algorithm\strong{:}
non-negative numeric (defaults to \code{1e-04})}
}
\value{
This function returns
the parameter estimates,
the posterior probabilities,
and the likelihood.
}
\description{
This function fits the semi-supervised Gaussian mixture model.
It is called by \code{\link{fit.wrap}}.
}
\examples{
# data simulation
n <- 100
z <- rep(0:1,each=n/2)
y <- rnorm(n=n,mean=2*z,sd=1)
z[(n/4):n] <- NA

# model fitting
fit.norm(y,z,it.em=100,epsilon=1e-04)

}
\seealso{
This is an \code{\link{internal}} function.
The user functions are \code{\link{mixtura}} and \code{\link{scrutor}}.
}
\keyword{internal}
