% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_signal_operations.R
\name{applySpline}
\alias{applySpline}
\title{applies a spline smoothing to a tidy data.table containing x and y values.}
\usage{
applySpline(
  dt,
  n,
  x_ = "x",
  y_ = "y",
  by_ = c("id", "sample"),
  splineFun = stats::spline
)
}
\arguments{
\item{dt}{a tidy data.table containing two-dimensional data}

\item{n}{the number of interpolation points to use per input point, see
\code{?spline}.  n must be > 1.}

\item{x_}{the variable name of the x-values}

\item{y_}{the variable name of the y-values}

\item{by_}{optionally, any variables that provide grouping to the data.
default is none. see details.}

\item{splineFun}{a function that accepts x, y, and n as arguments and
returns a list of length 2 with named elements x and y.
\code{stats::spline} by default.
see \code{stats::spline} for details.}
}
\value{
a newly derived data.table that is \code{n} times longer than
original.
}
\description{
\code{applySpline} Is intended for two-dimensional tidy data.tables, as
retured by \code{ssvFetchBigwig}
}
\details{
by_ is quite powerful.  If \code{by_ = c('gene_id', 'sample_id')},
splines
will be calculated individually for each gene in each sample. alternatively
if \code{by_ = c('gene_id')}
}
\examples{
data(CTCF_in_10a_profiles_dt)
#data may be blockier than we'd like
ggplot(CTCF_in_10a_profiles_dt[, list(y = mean(y)), by = list(sample, x)]) +
    geom_line(aes(x = x, y = y, color = sample))

#can be smoothed by applying a spline  (think twice about doing so,
#it may look prettier but may also be deceptive or misleading)

splined_smooth = applySpline(CTCF_in_10a_profiles_dt, n = 10,
    y_ = 'y', by_ = c('id', 'sample'))
ggplot(splined_smooth[, list(y = mean(y)), by = list(sample, x)]) +
    geom_line(aes(x = x, y = y, color = sample))
}
\seealso{
\code{\link{ssvFetchBigwig}}
}
