% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_exon_signal.R
\name{convert_collapsed_coord}
\alias{convert_collapsed_coord}
\title{convert_collapsed_coord}
\usage{
convert_collapsed_coord(genome_gr, x)
}
\arguments{
\item{genome_gr}{non-contiguous regions to collapse a la
\code{\link{collapse_gr}}}

\item{x}{numeric, positions within genome_gr to convert to collapsed
coordinates.}
}
\value{
numeric, positions of every value of x within collapse coordinates.
values outside of collapsed regions (an intron or outside range) will be NA.
}
\description{
(preliminary implementation, sub-optimal)
}
\details{
see \code{\link{collapse_gr}} for explanation of intended uses. this function
translates all values of x from original genomic coordinates to new
coordinate space created by \code{\link{collapse_gr}}.
}
\examples{
library(data.table)
library(GenomicRanges)
dev_dat = data.table(seqnames = "chrTest",
                     transcript_id = c(1, 1,  2, 2, 3, 3, 3),
                     start = c(5,  30,  8, 30, 2, 30, 40),
                     end = c(10, 35, 15, 38, 7, 35, 45),
                     strand = "+")

genome_gr = GRanges(dev_dat)
convert_collapsed_coord(genome_gr, start(genome_gr))
convert_collapsed_coord(genome_gr, end(genome_gr))
}
