% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_easyLoad.R
\name{easyLoad_FUN}
\alias{easyLoad_FUN}
\title{easyLoad_FUN takes a character vector of file paths run an arbitrary function defined in load_FUN}
\usage{
easyLoad_FUN(
  file_paths,
  load_FUN,
  file_names = NULL,
  n_cores = getOption("mc.cores", 1),
  ...
)
}
\arguments{
\item{file_paths}{character vector of paths to narrowPeak files.  If named,
those names will be used in output unless overriden by providing file_names.}

\item{load_FUN}{Arbitrary function that takes at least a file path as argument.  May take other arguments that should be set in call to easyLoad_FUN.}

\item{file_names}{character vector of names for output list.  If not NULL
will override any existing names for file_paths.  Default is NULL.}

\item{n_cores}{number of cores to use, uses mc.cores option if set or 1.}

\item{...}{extra parameters passed to load_FUN}
}
\value{
a named list of results from load_FUN
}
\description{
easyLoad_FUN takes a character vector of file paths run an arbitrary function defined in load_FUN
}
\examples{
bed_f = system.file("extdata/test_loading.bed",
    package = "seqsetvis", mustWork = TRUE)
easyLoad_bed(bed_f, "my_bed")
}
