% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_signal.R
\name{ssvFetchSignal}
\alias{ssvFetchSignal}
\title{signal loading framework}
\usage{
ssvFetchSignal(
  file_paths,
  qgr,
  unique_names = NULL,
  names_variable = "sample",
  file_attribs = NULL,
  win_size = 50,
  win_method = c("sample", "summary")[1],
  return_data.table = FALSE,
  load_signal = function(f, nam, qgr) {
     warning("nothing happened, ",
    "supply a function to", "load_signal parameter.")
 },
  n_cores = getOption("mc.cores", 1),
  n_region_splits = 1,
  force_skip_centerFix = FALSE
)
}
\arguments{
\item{file_paths}{character vector of file_paths to load from. Alternatively,
file_paths can be a data.frame or data.table whose first column is a
character vector of paths and additial columns will be used as metadata.}

\item{qgr}{GRanges of intervals to return from each file}

\item{unique_names}{unique file ids for each file in file_paths.  Default is
names of file_paths vector}

\item{names_variable}{character, variable name for column containing
unique_names entries.  Default is "sample"}

\item{file_attribs}{optional data.frame/data.table with one row per item in
file paths.  Each column will be a variable added to final tidy output.}

\item{win_size}{numeric/integer window size resolution to load signal at.
Default is 50.}

\item{win_method}{character.  one of c("sample", "summary").  Determines if
\code{\link{viewGRangesWinSample_dt}} or
\code{\link{viewGRangesWinSummary_dt}} is used to represent each region in
qgr.}

\item{return_data.table}{logical. If TRUE data.table is returned instead of
GRanges, the default.}

\item{load_signal}{function taking f, nam, and qgr arguments.  f is from
file_paths, nam is from unique_names, and qgr is qgr. See details.}

\item{n_cores}{integer number of cores to use. Uses mc.cores option if not
supplied.}

\item{n_region_splits}{integer number of splits to apply to qgr. The query
GRanges will be split into this many roughly equal parts for increased
parallelization. Default is 1, no split.}

\item{force_skip_centerFix}{boolean, if TRUE all query ranges will be used
"as is".  This is already the case by default if win_method == "summary"
but may have applications where win_method == "sample".}
}
\value{
A GRanges with values read from file_paths at intervals of win_size.
Originating file is coded by unique_names and assigned to column of name
names_variable.  Output is data.table is return_data.table is TRUE.
}
\description{
Does nothing unless load_signal is overridden to carry out reading data from
file_paths (likely via the appropriate ssvFetch* function, ie.
\code{\link{ssvFetchBigwig}} or \code{\link{ssvFetchBam}}
}
\details{
load_signal is passed f, nam, and qgr and is executed in the
environment where load_signal is defined. See \code{\link{ssvFetchBigwig}}
and \code{\link{ssvFetchBam}} for examples.
}
\examples{
library(GenomicRanges)
data(CTCF_in_10a_overlaps_gr)
bam_f = system.file("extdata/test.bam",
    package = "seqsetvis", mustWork = TRUE)
bam_files = c("a" = bam_f, "b" = bam_f)
qgr = CTCF_in_10a_overlaps_gr[1:2]
qgr = resize(qgr, 500, "center")
load_bam = function(f, nam, qgr) {
    message("loading ", f, " ...")
    dt = seqsetvis:::ssvFetchBam.single(bam_f = f,
                      qgr = qgr,
                      win_size = 50,
                      fragLen = NULL,
                      target_strand = "*",
                      return_data.table = TRUE)

    data.table::set(dt, j = "sample", value = nam)
    message("finished loading ", nam, ".")
    dt
}
ssvFetchSignal(bam_files, qgr, load_signal = load_bam)
}
