% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{calcEffectSize}
\alias{calcEffectSize}
\title{Compute effect size for different variables from prediction matrix}
\usage{
calcEffectSize(pred)
}
\arguments{
\item{pred}{predictions}
}
\value{
a data.frame of effect sizes. Columns are different variables.
Rows are different probes.
}
\description{
The effect size is defined by the maximum variation of a variable with all
the other variables controled constant.
}
\examples{
data <- sesameDataGet('HM450.76.TCGA.matched')
res <- DMLpredict(data$betas[1:10,], ~type, meta=data$sampleInfo)
head(calcEffectSize(res))
}
