% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{CommandLineBinding-class}
\alias{CommandLineBinding-class}
\alias{CommandLineBinding}
\title{CommandLineBinding Class}
\description{
When listed under inputBinding in the input schema, the term
"value" refers to the the corresponding value in the input
object. For binding objects listed in CommandLineTool.arguments,
the term "value" refers to the effective value after evaluating
valueFrom.
}
\details{
The binding behavior when building the command line
depends on the data type of the value. If there is a mismatch
between the type described by the input schema and the effective
value, such as resulting from an expression evaluation, an
implementation must use the data type of the effective value.
\itemize{
  \item{character}{Add prefix and the string to the command line.}
  \item{numeric}{Add prefix and decimal representation to command line.}
  \item{logical}{If true, add prefix to the command line. If false,
add nothing.}
  \item{File}{Add prefix and the value of File.path to the command line.}
  \item{*Array}{If itemSeparator is specified, add prefix and the join the
  array into a single string with itemSeparator separating the items.
  Otherwise add prefix and recursively add individual elements.}
\item{*object}{Add prefix only, and recursively add object fields for
which inputBinding is specified.}
 \item{null}{Add nothing.}
}
}
\section{Fields}{

\describe{
\item{\code{position}}{[integer] The sorting key. Default position is 0.}

\item{\code{prefix}}{[character] Command line prefix to add before the value.}

\item{\code{separate}}{[logical] If true (default) then the prefix and
value must be added as separate command line arguments; if false,
prefix and value must be concatenated into a single command line
argument.}

\item{\code{itemSeparator}}{[character] Join the array elements into a
single string with the elements separated by by itemSeparator.}

\item{\code{valueFrom}}{[characterOrExpression] If valueFrom is a constant
string value, use this as the value and apply the binding rules
above. If valueFrom is an expression, evaluate the expression to
yield the actual value to use to build the command line and apply
the binding rules above. If the inputBinding is associated with an
input parameter, the "context" of the expression will be the value
of the input parameter. When a binding is part of the
CommandLineTool.arguments field, the valueFrom field is required.}
}}


\examples{
CommandLineBinding(position = 1L, prefix = "-l")
}
