% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{CommandLineTool-class}
\alias{CommandLineTool-class}
\alias{CommandLineTool}
\title{CommandLineTool Class}
\description{
A CommandLineTool process is a process implementation for executing
a non-interactive application in a POSIX environment. To help
accomodate of the enormous variety in syntax and semantics for
input, runtime environment, invocation, and output of arbitrary
programs, CommandLineTool provides the concept of "input binding"
to describe how to translate input parameters to an actual program
invocation, and "output binding" to describe how generate output
parameters from program output.
}
\section{Fields}{

\describe{
\item{\code{baseCommand}}{(character) Specifies the program to execute. If
the value is an array, the first element is the program to execute,
and subsequent elements are placed at the beginning of the command
line in prior to any command line bindings. If the program includes
a path separator character it must be an absolute path, otherwise
it is an error. If the program does not include a path separator,
search the $PATH variable in the runtime environment find the
absolute path of the executable.}

\item{\code{arguments}}{[characterORCommandLineBinding] Command line
bindings which are not directly associated with input parameters.}

\item{\code{stdin}}{[characterORExpression] A path to a file whose
contents must be piped into the command's standard input stream.}

\item{\code{stdout}}{[characterORExpression] Capture the command's
standard output stream to a file written to the designated output
directory. If stdout is a string, it specifies the file name to
use.If stdout is an expression, the expression is evaluated and
must return a string with the file name to use to capture
stdout. If the return value is not a string, or the resulting path
contains illegal characters (such as the path separator /) it is an
error.}

\item{\code{successCodes}}{[integer] Exit codes that indicate the process
completed successfully.}

\item{\code{temporaryFailCodes}}{[integer] Exit codes that indicate the
process failed due to a possibly temporary condition, where
excuting the process with the same runtime environment and inputs
may produce different results.}

\item{\code{permanentFailCodes}}{[integer] Exit codes that indicate the
process failed due to a permanent logic error, where excuting the
process with the same runtime environment and same inputs is
expected to always fail.}
}}


\section{Input binding}{


The tool command line is built by applying command line bindings to
the input object. Bindings are listed either as part of an input
parameter using the inputBinding field, or separately using the
arguments field of the CommandLineTool.

The algorithm to build the command line is as follows. In this
algorithm, the sort key is a list consisting of one or more numeric
and string elements. Strings are sorted lexicographically based on
UTF-8 encoding.

\itemize{

\item{}{Collect CommandLineBinding objects from arguments. Assign a
sorting key [position, i] where position is
CommandLineBinding.position and the i is the index in the arguments
list.}

\item{}{Collect CommandLineBinding objects from the inputs schema
and associate them with values from the input object. Where the
input type is a record, array, or map, recursively walk the schema
and input object, collecting nested CommandLineBinding objects and
associating them with values from the input object.  }

\item{}{Assign a sorting key for each leaf binding object by appending
nested position fields together with the array index, or map key of
the data at each nesting level. If two bindings have the same
position, the tie must be broken using the lexographic ordering of
the field or parameter name immediately containing the binding.}

\item{}{Sort elements using the assigned sorting keys. Numeric
entries sort before strings.}

\item{}{In the sorted order, apply the rules defined in
CommandLineBinding to convert bindings to actual command line
elements.}

\item{}{Insert elements from baseCommand at the beginning of the
command line.}

}
}

\section{Runtime environment}{


All files listed in the input object must be made available in the
runtime environment. The implementation may use a shared or
distributed file system or transfer files via explicit
download. Implementations may choose not to provide access to files
not explicitly specified by the input object or process
requirements.

Output files produced by tool execution must be written to the
designated output directory.

The initial current working directory when executing the tool must
be the designated output directory.

The TMPDIR environment variable must be set in the runtime
environment to the designated temporary directory. Any files
written to the designated temporary directory may be deleted by the
workflow platform when the tool invocation is complete.

An implementation may forbid the tool from writing to any location
in the runtime environment file system other than the designated
temporary directory and designated output directory. An
implementation may provide read-only input files, and disallow
in-place update of input files.

The standard input stream and standard output stream may be
redirected as described in the stdin and stdout fields.
}

\section{Extensions}{


DockerRequirement, CreateFileRequirement, and EnvVarRequirement,
are available as standard extensions to core command line tool
semantics for defining the runtime environment.
}

\section{Execution}{


Once the command line is built and the runtime environment is
created, the actual tool is executed.

The standard error stream and standard output stream (unless
redirected by setting stdout) may be captured by platform logging
facilities for storage and reporting.

Tools may be multithreaded or spawn child processes; however, when
the parent process exits, the tool is considered finished
regardless of whether any detached child processes are still
running. Tools must not require any kind of console, GUI, or web
based user interaction in order to start and run to completion.

The exit code of the process indicates if the process completed
successfully. By convention, an exit code of zero is treated as
success and non-zero exit codes are treated as failure. This may be
customized by providing the fields successCodes,
temporaryFailCodes, and permanentFailCodes. An implementation may
choose to default unspecified non-zero exit codes to either
temporaryFailure or permanentFailure.
}

\section{Output binding}{


If the output directory contains a file called "cwl.output.json",
that file must be loaded and used as the output object. Otherwise,
the output object must be generated by walking the parameters
listed in outputs and applying output bindings to the tool
output. Output bindings are associated with output parameters using
the outputBinding field. See CommandOutputBinding for details.
}

\examples{
ipl <- InputParameterList(
  InputParameter(
    id = "BAM", type = "File",
    label = "input bam",
    description = "input bam",
    inputBinding = CommandLineBinding(
      position = 1L
    )
  ),
  InputParameter(
    id = "level", type = "Integer",
    label = "Compression level",
    description = "Compression level",
    inputBinding = CommandLineBinding(
      position = 2L,
      prefix = "-l"
    )
  )
)

clt <- CommandLineTool(inputs = ipl, baseCommand = "samtools sort")
}
