% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{FileList}
\alias{FileList}
\alias{FileList-class}
\alias{File-class}
\alias{File}
\title{FileList Class}
\usage{
FileList(...)
}
\arguments{
\item{\dots}{element or list of the element.}
}
\value{
File class generator
}
\description{
FileList Class

File Class
}
\section{Fields}{

\describe{
\item{\code{class}}{(character) Must be File to indicate this object
describes a file.}

\item{\code{path}}{(character) The path to the file.}

\item{\code{checksum}}{[character] Optional hash code for validating file
integrity. Currently must be in the form "sha1$ + hexidecimal
string" using the SHA-1 algorithm.}

\item{\code{size}}{[numeric] Optional file size.}

\item{\code{secondaryFile}}{[FileList] A list of additional files that are
associated with the primary file and must be transferred alongside
the primary file. Examples include indexes of the primary file, or
external references which must be included when loading primary
document. A file object listed in secondaryFiles may itself include
secondaryFiles for which the same rules apply.}
}}


\examples{
library(jsonlite)
library(yaml)
f1 <- File()
f2 <- File(path = "./out.bam", checksum = "test",
           size = 3L, secondaryFile = FileList(File(path = "./out.bai")))
fl <- FileList(f1, f2)
asList(fl)
f1
f2
fl
}
