% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{ProcessRequirement-class}
\alias{ProcessRequirement-class}
\alias{ProcessRequirement}
\alias{DockerRequirement-class}
\alias{DockerRequirement}
\alias{SubworkflowFeatureRequirement-class}
\alias{SubworkflowFeatureRequirement}
\alias{FileDef-class}
\alias{FileDef}
\alias{FileDefList}
\alias{FileDefList-class}
\alias{CreateFileRequirement-class}
\alias{CreateFileRequirement}
\alias{EnvironmentDef-class}
\alias{EnvironmentDef}
\alias{EnvironmentDefList}
\alias{EnvironmentDefList-class}
\alias{EnvVarRequirement-class}
\alias{EnvVarRequirement}
\alias{ScatterFeatureRequirement-class}
\alias{ScatterFeatureRequirement}
\alias{ProcessRequirementList}
\alias{ProcessRequirementList-class}
\alias{ExpressionEngineRequirement-class}
\alias{ExpressionEngineRequirement}
\title{ProcessRequirement Class}
\usage{
FileDefList(...)

EnvironmentDefList(...)

ProcessRequirementList(...)
}
\arguments{
\item{\dots}{element or list of the element.}
}
\value{
a ProcessRequirement object or subclass object.
}
\description{
ProcessRequirement Class

DockerRequirement Class

ProcessRequirementList
}

\section{ProcessRequirement}{


\describe{ A process requirement
modifies the semantics or runtime environment of a process. If an
implementation cannot satisfy all requirements, or a requirement is
listed which is not recognized by the implementation, it is a fatal
error and the implementation must not attempt to run the process,
unless overridden at user option.

\item{\code{class}}{(character) The specific requirement type.}
}
}

\section{DockerRequirement Class}{

\describe{

Indicates that a workflow component should be run in a Docker
container, and specifies how to fetch or build the image.
If a CommandLineTool lists DockerRequirement under hints or
requirements, it may (or must) be run in the specified Docker
container. The platform must first acquire or install the correct
Docker image, as described by DockerRequirement. The platform must
execute the tool in the container using docker run with the
appropriate Docker image and the tool command line. The workflow
platform may provide input files and the designated output
directory through the use of volume bind mounts. The platform may
rewrite file paths in the input object to correspond to the Docker
bind mounted locations. When running a tool contained in Docker,
the workflow platform must not assume anything about the contents
of the Docker container,such as the presence or absence of specific
software, except to assume that the generated command line
represents a valid command within the runtime environment of the
container.

\item{\code{dockerPull}}{(character) Get a Docker image using
docker pull}

\item{\code{dockerLoad}}{(character) Specify a HTTP URL from which
to download a Docker image using docker load.}

\item{\code{dockerFile}}{(character) Supply the contents of a
Dockerfile which will be build using docker build.}

\item{\code{dockerImageId}}{(character) The image id that will be
used for docker run. May be a human-readable image name or the
image identifier hash. May be skipped if dockerPull is specified,
in which case the dockerPull image id will be used.}

\item{\code{dockerOutputDirectory}}{(character) Set the designated
output directory to a specific location inside the Docker
container.}

}
}

\section{SubworkflowFeatureRequirement Class}{


Indicates that the workflow platform must support nested workflows
in the run field of (WorkflowStep)(#workflowstep).
}

\section{FileDef Class}{


\describe{

Define a file that must be placed by in the designated output
directory prior to executing the command line tool. May be the
result of executing an expression, such as building a configuration
file from a template.

\item{\code{filename}}{(characterORExpression) The name of the file
to create in the output directory.}

\item{\code{fileContent}}{(characterORExpression) If the value is a
string literal or an expression which evalutes to a string, a new
file must be created with the string as the file contents. If the
value is an expression that evaluates to a File object, this
indicates the referenced file should be added to the designated
output directory prior to executing the tool. Files added in this
way may be read-only, and may be implemented through bind mounts or
file system links in such a way as to avoid unecessary copying of
the input file.}

}
}

\section{CreateFileRequirement Class}{

\describe{

Define a list of files that must be created and placed by the
workflow platform in the designated output directory prior to
executing the command line tool. See FileDef for details.

\item{\code{fileDef}}{(FileDefList) The list of files.}

}
}

\section{EnvironmentDef Class}{

\describe{

Define an environment variable that will be set in the runtime
environment by the workflow platform when executing the command
line tool. May be the result of executing an expression, such as
getting a parameter from input.

\item{\code{envName}}{(character) The environment variable name. }

\item{\code{envValue}}{(characterORExpression) The environment
variable value.}

}
}

\section{EnvVarRequirement Class}{

\describe{

Define a list of environment variables which will be set in the
execution environment of the tool. See EnvironmentDef for details.

\item{\code{envDef}}{(EnvironmentDefList) The list of environment
variables.}

}
}

\section{ScatterFeatureRequirement Class}{


Indicates that the workflow platform must support the scatter and
scatterMethod fields of (WorkflowStep)(#workflowstep).
}

\section{ExpressionEngineRequirement Class}{

\describe{

Define an expression engine, as described in Expressions.

\item{\code{id}}{(character) Used to identify the expression engine in the
engine field of Expressions.}

\item{\code{requirements}}{[ProcessRequirement]Requirements to run this
expression engine, such as DockerRequirement for specifying a
container with the engine.}

\item{\code{engineCommand}}{ [character] The command line to invoke the
expression engine.}

\item{\code{engineConfig}}{ [character] Additional configuration or code
fragments that will also be passed to the expression engine. The
semantics of this field are defined by the underlying expression
engine. Intended for uses such as providing function definitions
that will be called from CWL expressions.}

}
}

\examples{
dkr <- DockerRequirement(dockerImageId = "testid")
cfr <- CreateFileRequirement(fileDef = FileDefList(FileDef(filename = "hello.txt")))
sfr <- SubworkflowFeatureRequirement()
evr <- EnvVarRequirement(envDef = EnvironmentDefList(
  EnvironmentDef(envName = "path", envValue = "testpath")
))
safr <- ScatterFeatureRequirement()
eer <- ExpressionEngineRequirement(id = "hello")
ProcessRequirementList(dkr, cfr, sfr, evr, safr, eer)
}
