% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{WorkflowOutputParameter-class}
\alias{WorkflowOutputParameter-class}
\alias{WorkflowOutputParameter}
\alias{WorkflowOutputParameterList}
\alias{WorkflowOutputParameterList-class}
\alias{Workflow-class}
\alias{Workflow}
\title{Workflow}
\usage{
WorkflowOutputParameterList(...)
}
\arguments{
\item{\dots}{element or list of the element.}
}
\value{
a Workflow object.
}
\description{
A workflow is a process consisting of one or more steps. Each step
has input and output parameters defined by the inputs and outputs
fields. A workflow executes as described in execution model.
}
\section{Fields}{

\describe{
\item{\code{outputs}}{(WorkflowOutputParameterList) Defines the parameters
representing the output of the process. May be used to generate
and/or validate the output object. Inherited from Process}

\item{\code{steps}}{(WorkflowStepList) The individual steps that make up the
workflow. Steps are executed when all input data links are
fufilled. An implementation may choose to execute the steps in a
different order than listed and/or execute steps concurrently,
provided that dependencies between steps are met.}
}}


\section{WorkflowOutputParameter Class}{

\describe{
Describe an output parameter of a workflow. The parameter must be
connected to one or more parameters defined in the workflow that
will provide the value of the output parameter.

\item{\code{source}}{ [character] Specifies one or more workflow parameters
that will provide this output value.}

\item{\code{linkMerge}}{ [LinkMergeMethod] The method to use to merge
multiple inbound links into a single array. If not specified, the
default method is merge_nested:}
}
}

\section{Dependencies}{


Dependencies between parameters are expressed using the source
field on workflow step input parameters and workflow output
parameters.

The source field expresses the dependency of one parameter on
another such that when a value is associated with the parameter
specified by source, that value is propagated to the destination
parameter. When all data links inbound to a given step are
fufilled, the step is ready to execute.
}

\section{Extensions}{


ScatterFeatureRequirement and SubworkflowFeatureRequirement are
available as standard extensions to core workflow semantics.
}

\examples{
# need better examples here
ws <- WorkflowStepList(
    WorkflowStep(
        id = "step1", label = "align-and-sort",
        description = "align and sort",
        inputs = WorkflowStepInputList(
            WorkflowStepInput(id = "id1"),
            WorkflowStepInput(id = "id2")
        )
    )
)
Workflow(steps = ws)
}
