% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{methods}
\name{asList}
\alias{asList}
\alias{asList,ANY-method}
\alias{asList,CWL-method}
\alias{asList,SingleEnum-method}
\alias{asList,SimpleList-method}
\alias{asList,DSCList-method}
\title{Convert a object slots/fields to a list, json, or yaml file}
\usage{
asList(object, ...)

\S4method{asList}{ANY}(object, ...)

\S4method{asList}{CWL}(object, ...)

\S4method{asList}{SingleEnum}(object, ...)

\S4method{asList}{SimpleList}(object, ...)

\S4method{asList}{DSCList}(object, ...)
}
\arguments{
\item{object}{object, could be S4/R5 object.
For example, class CWL, SimpleList.}

\item{...}{other parameters passed to \code{as.yaml} or \code{toJSON}.}
}
\value{
a list object or json or yaml file.
}
\description{
Doesn't like \code{as.list}, only fields and slots are converted,
prepare a object to be conveted to YAML/JSON.
}
\examples{
# define a S4 object
A <- setClass("A", slots = list(a = "character", b = "numeric"))
# define a reference object which extends 'CWL' class
B <- setRefClass("B", fields = list(x = "character", y = "A"), contains = "CWL")
# new instances
a <- A(a = "hello", b = 123)
b <- B(x = "world", y = a)

# show
b
b$show("JSON")
b$show("YAML")

# You can convert slots/fields into a list
asList(a)
asList(b)
b$toList()
b$toYAML()
b$toJSON()
}
