% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-task.R
\name{batch}
\alias{batch}
\title{batch function for task batch execution}
\usage{
batch(input = NULL, criteria = NULL, type = c("ITEM", "CRITERIA"))
}
\arguments{
\item{input}{character, ID of the input on which you wish to batch on.
You would usually batch on the input containing a list of files.
If left out, default batching criteria defined in the app is used.}

\item{criteria}{a character vector, for example.
\code{c("metadata.sample_id", "metadata.library_id")}. The meaning of the
above batch_by dictionary is - group inputs (usually files) first on sample
ID and then on library ID. If NULL, using type "ITEM" by default.}

\item{type}{Criteria on which to batch on - can be in two formats."ITEM" and
"CRITERIA". If you wish to batch per item in the input (usually a file)
using "ITEM". If you wish a more complex criteria, specify the "CRITERIA"
on which you wish to group inputs on. Please check examples.}
}
\value{
a list of 'batch_input' and 'batch_by' used for task batch
}
\description{
batch function for task batch execution
}
\examples{
batch(input = "fastq") # by ITEM
batch(input = "fastq", c("metadata.sample_id", "metadata.library_id"))
# shorthand for this
batch(input = "fastq", c("metadata.sample_id", "metadata.library_id"), type = "CRITERIA")
}
