% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-flow.R
\docType{methods}
\name{link}
\alias{link}
\alias{link,Tool,Tool-method}
\alias{link,Tool,Workflow-method}
\alias{link,Workflow,Tool-method}
\alias{link,Workflow,Workflow-method}
\alias{link,App,ToolORWorkflow-method}
\alias{link,ToolORWorkflow,App-method}
\title{link two nodes to form a new Workflow}
\usage{
link(from, to, ...)

\S4method{link}{Tool,Tool}(
  from,
  to,
  id1,
  id2,
  flow_id = NULL,
  flow_label = NULL,
  flow_input = NULL,
  flow_output = NULL
)

\S4method{link}{Tool,Workflow}(
  from,
  to,
  id1,
  id2,
  flow_id = NULL,
  flow_label = NULL,
  flow_input = NULL,
  flow_output = NULL
)

\S4method{link}{Workflow,Tool}(
  from,
  to,
  id1,
  id2,
  flow_id = NULL,
  flow_label = NULL,
  flow_input = NULL,
  flow_output = NULL
)

\S4method{link}{Workflow,Workflow}(from, to, id1, id2)

\S4method{link}{App,ToolORWorkflow}(from, to, id1, id2)

\S4method{link}{ToolORWorkflow,App}(from, to, id1, id2)
}
\arguments{
\item{from}{either Tool App or Workflow object}

\item{to}{either Tool App or Workflow object}

\item{...}{more auguments}

\item{id1}{id to be connected from the ouput of the first node}

\item{id2}{id id to be connected from the input of the second first node}

\item{flow_id}{workflow id, if ignored, going to create one by joning tool id.}

\item{flow_label}{workflow label, if ignored, going to create one by joning tool labels.}

\item{flow_input}{full flow input id, e.g. "#SBG_Unpack_FASTQs.input_archive_file"}

\item{flow_output}{full flow output id, e.g. "#STAR.log_files"}
}
\value{
A Workflow object
}
\description{
link two nodes to form a new Workflow
}
\details{
Flexible enought to allow users to connect two objects by ids
}
\examples{
t1 <- system.file("extdata/app", "tool_unpack_fastq.json", package = "sevenbridges")
t2 <- system.file("extdata/app", "tool_star.json", package = "sevenbridges")
t1 <- convert_app(t1)
t2 <- convert_app(t2)
# check possible link
link_what(t1, t2)
# link
f1 <- link(t1, t2, "output_fastq_files", "reads")
# link
f2 <- link(
  t1, t2, "output_fastq_files", "reads",
  flow_input = "#SBG_Unpack_FASTQs.input_archive_file",
  flow_output = "#STAR.log_files"
)
}
