% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtnetplot.R
\name{dtnetplot}
\alias{dtnetplot}
\title{Drug-Target Network Visualization}
\usage{
dtnetplot(drugs, set, ont = NULL, desc = NULL, verbose = FALSE, ...)
}
\arguments{
\item{drugs}{A character vector of drug names}

\item{set}{character(1) GO term ID, KEGG or Reactome pathway ID. 
Alternatively, a character vector of gene SYMBOLs can be assigned.}

\item{ont}{if `set` is a GO term ID, `ont` is the corresponding ontology 
that GO term belongs to. One of 'BP', 'MF' or 'CC'. If `set` is anything else,
`ont` is ignored.}

\item{desc}{character(1), description of the chosen functional category or 
target set}

\item{verbose}{TRUE or FALSE, whether to print messages}

\item{...}{Other arguments passed on to 
\code{\link[visNetwork]{visNetwork}} function.}
}
\value{
visNetwork plot and a list of drugs and targets that have interactions
}
\description{
Functional modules of GESS and FEA results can be rendered as interactive
drug-target networks using the \code{dtnetplot} function form
\code{signatureSearch}. For this, a character vector of drug names along 
with an identifier of a chosen functional category are passed on to the 
drugs and set arguments, respectively. The resulting plot depicts the 
corresponding drug-target interaction network. Its interactive features 
allow the user to zoom in and out of the network, and to select network 
components in the drop-down menu located in the upper left corner of the 
plot.
}
\examples{
data(drugs10)
dtnetplot(drugs=drugs10, 
    set=c("HDAC1", "HDAC2", "HDAC3", "HDAC11", "FOX2"),
    desc="NAD-dependent histone deacetylase activity (H3-K14 specific)")
}
