% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsMethods.R
\name{spearmanCorrMethod}
\alias{spearmanCorrMethod}
\title{Spearman's rho statistic of two profiles}
\usage{
spearmanCorrMethod(profile1, profile2, threshold = 1e-08)
}
\arguments{
\item{profile1}{a \code{vector} of \code{numeric} values, the first profile
containing the alignment depth for each position. The \code{profile1} and 
\code{profile2} should have the same length.}

\item{profile2}{a \code{vector} of \code{numeric} values, the second profile
containing the alignment depth for each position. The \code{profile1} and 
\code{profile2} should have the same length.}

\item{threshold}{a \code{numeric}, the minimum standard deviation accepted 
to calculate a ratio. Default = 1e-8}
}
\value{
The calculated ratio or \code{NA} if one profile has a standard 
deviation inferior to the threshold. If profiles have no complete element 
pair, \code{NA} is returned.
}
\description{
Calculate and return the Spearman's rho statistic of two 
profiles. If one profile has a standard deviation inferior to 
the threshold, the function returns \code{NA}. When no complete element 
pair are present, \code{NA} is returned.
}
\seealso{
\itemize{
\item \code{\link{MetricFactory}} {for using the recommanded interface to 
calculate all available metrics separately or togheter.}
}
}
\author{
Astrid Deschenes, Elsa Bernatchez
}
