% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbb-step1-fit.R
\name{CIP_GIP_test}
\alias{CIP_GIP_test}
\title{Cell and Gene Importance Projections statistical significance}
\usage{
CIP_GIP_test(
  object,
  npermut = 100,
  maxiter = 100,
  type = c("jackknife", "subsampling"),
  nsubsampling = 100,
  ...
)
}
\arguments{
\item{object}{A superpathway fit model list}

\item{npermut}{Number of permutations on response block matrices}

\item{maxiter}{An integer indicating the maximum number of iterations.
If \code{NULL} the default is 100.}

\item{type}{Either \code{jackknife} or \code{subsampling}. If \code{jackknife} then the CIP
and GIP observed distribution is generated by a jackknife procedure. If
\code{subsampling} the CIP and GIP observed distribution is generated by
subsampling the number of samples without replacement, each subsample is
guaranteed to contain at least 2 samples per class. If a LOOCV was performed
or one has small sample size it is recommended to select \code{jackknife},
otherwise select \code{subsampling}.}

\item{nsubsampling}{Number of subsamples to generate CIP and GIP observed
distributions. By default 100.}

\item{...}{Other parameters to be passed onto \link{wilcox_CIP_GIP}}
}
\value{
A list containing; observed distributions of CIP and GIP (variability_param);
its associated null distributions generated by permutations (NULL_CIP_GIP);
the unadjusted pvalue of Mann-Whitney Wilcoxon for CIP distribution
(CIP_pvalue); and for GIP distribution (GIP_pvalue).
}
\description{
Computes Cell and Gene Importance Projection observed distribution from
fitted asmbPLSDA, and its associated null distributions by permuting the
block of predictor matrices. Returns a pvalue of the Mann-Whitney Wilcoxon
between the observed and null distribution for each CIP and GIP.
}
\examples{
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
data <- example_superpathway_fit_model
CIP_GIP_test(data, npermut = 3, type = "jackknife")
}
