% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{add_missing_psb_rows}
\alias{add_missing_psb_rows}
\title{Ensure all celltype–sample combinations are present in the pseudobulkmatrix}
\usage{
add_missing_psb_rows(mat, celltypes, sample_ids)
}
\arguments{
\item{mat}{A numeric matrix with rownames in the form “celltype_sample”.}

\item{celltypes}{Character vector of the celltypes you intend to include
(in the exact order of \code{object@superpathway_info@celltypes}).}

\item{sample_ids}{Character vector of all sample identifiers
(in the order of \code{rownames(object@pseudobulk_lognorm)} split by “_”).}
}
\value{
A numeric matrix with \code{length(celltypes) * length(sample_ids)}
rows, in the canonical \code{paste(celltypes, sample_ids, sep = "_")}
order, where newly added rows are filled with \code{NA_real_}.
}
\description{
Ensure all celltype–sample combinations are present in the pseudobulkmatrix
}
