% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{check_superpathway}
\alias{check_superpathway}
\title{Validate superpathway gene sets}
\usage{
check_superpathway(pathway_info, celltypes, gene_sets_celltype)
}
\arguments{
\item{pathway_info}{List. A pathway object created by create_pathway().}

\item{celltypes}{Character vector. Each element represents a cell type.}

\item{gene_sets_celltype}{List of character vectors. Each element corresponds
to gene sets for each cell type. Can be NULL.}
}
\value{
TRUE if all checks pass; otherwise, an error is thrown.
}
\description{
Checks that all provided fields for a superpathway meet the expected properties:
\itemize{
\item pathway_info must be a valid pathway (validated with check_pathway()).
\item celltypes must be a character vector with at least 2 elements.
\item gene_sets_celltype must be a list (or NULL) with same length as celltypes.
}
}
\examples{
my_pathway <- create_pathway("KEGG_CYTOKINE_CYTOKINE_RECEPTOR_INTERACTION",
"KEGG", "c2", "CP")
check_superpathway(my_pathway, c("T-cell", "Dendritic Cell"), list(c("IL4",
"IL5"), c("IL13")))
}
