% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{check_superpathway_input}
\alias{check_superpathway_input}
\title{Check superpathway input for asmbPLS-DA}
\usage{
check_superpathway_input(
  superpathway_info,
  hyperparameters_info,
  pseudobulk_lognorm,
  sample_id,
  sample_class,
  base_class,
  target_class
)
}
\arguments{
\item{superpathway_info}{A list representing a superpathway object.}

\item{hyperparameters_info}{A list representing a hyperparameters object.}

\item{pseudobulk_lognorm}{A pseudobulk matrix (rows: "Celltype_Sampleid",
cols: genes in "HGNC" format or similar).}

\item{sample_id}{A character vector of sample ids.}

\item{sample_class}{A character vector with the class of each sample.}

\item{base_class}{A character scalar indicating the base class.}

\item{target_class}{A character scalar indicating the target class.}
}
\value{
Invisibly returns \code{TRUE} if all checks pass; otherwise errors.
}
\description{
Checks the validity of the inputs. This version assumes that
\code{superpathway_info} and \code{hyperparameters_info} are plain lists
validated by \code{check_superpathway()} and \code{check_hyperparameters()}.
}
\examples{
# ---- Superpathway info (list) ----
my_pathway <- create_pathway("KEGG_CYTOKINE_CYTOKINE_RECEPTOR_INTERACTION",
"KEGG", "c2", "CP")
celltypes <- c("T-cell", "Dendritic Cell")

my_superpathway <- create_superpathway(my_pathway, celltypes, list(c("IL4",
"IL5"), c("IL13")))
# ---- Hyperparameters info (list) ----
quantile_comb_table <- base::as.matrix(
  RcppAlgos::permuteGeneral(seq(0.05, 0.95, by = 0.50)),
  ncol = length(celltypes)
)

my_hyperparameters <- create_hyperparameters(
  quantile_comb_table = quantile_comb_table,
  outcome_type = "binary",
  number_PLS = as.integer(3),
  folds_CV = as.integer(1),
  repetition_CV = as.integer(1)
)

# ---- Pseudobulk + labels ----
sample_id <- c("AD1", "AD2", "HC1", "HC2")
sample_class <- c("AD", "AD", "HC", "HC")
base_class <- "HC"
target_class <- "AD"

pseudobulk_lognorm <- matrix(
  rnorm(length(celltypes) * length(sample_id)),
  nrow = length(celltypes) * length(sample_id),
  ncol = length(celltypes)
)
rownames(pseudobulk_lognorm) <- as.vector(t(outer(
  celltypes, sample_id, function(x, y) paste(x, y, sep = "_")
)))

check_superpathway_input(
  superpathway_info = my_superpathway,
  hyperparameters_info = my_hyperparameters,
  pseudobulk_lognorm = pseudobulk_lognorm,
  sample_id = sample_id,
  sample_class = sample_class,
  base_class = base_class,
  target_class = target_class
)
}
