% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step3-contributions.R
\name{derive_contributions}
\alias{derive_contributions}
\title{Derive superpathway score, cell type contribution and gene
contribution}
\usage{
derive_contributions(model_object, data)
}
\arguments{
\item{model_object}{A superpathway fit model list with the fitted asmbPLSDA}

\item{data}{A matrix with the block of predictor matrices to compute
score and contributions from}
}
\value{
A list with the superpathway score for each sample, cell type and gene
contributions to the former
}
\description{
Computes the superpathway score, its cell type contribution and gene
contribution for a block of predictor matrices for its later use to compute
recapitulations
}
\examples{
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
mapped <- example_mapping_organism
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
model <- example_superpathway_fit_model
\donttest{singIST_samples <- biological_link_function(mapped,
model)$singIST_samples
derive_contributions(model, singIST_samples)
}
}
