% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step3-contributions.R
\name{derive_scores}
\alias{derive_scores}
\title{Compute predictor scores}
\usage{
derive_scores(object, data, sample)
}
\arguments{
\item{object}{A superpathway fit model list passed from
\link{derive_contributions}}

\item{data}{Block of predictor matrices to compute scores from}

\item{sample}{Current sample from \code{data} to compute scores}
}
\value{
A list containing the needed parameters to compute superpathway's score,
cell type contributions and needed scores to compute gene contributions
}
\description{
Computes scores from the predictor to later derive the superpathway's score,
cell type contribution and gene contributions, for the target class
}
\examples{
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
mapped <- example_mapping_organism
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
model <- example_superpathway_fit_model
\donttest{singIST_samples <- biological_link_function(mapped,
model)$singIST_samples
# Derive the scores for sample 2
derive_scores(model, singIST_samples, 2)}
}
