% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step4-recapitulations.R
\name{gene_contrib}
\alias{gene_contrib}
\title{Derive gene contribution to cell type recapitulation}
\usage{
gene_contrib(model_object, data_original, data_singIST, cell_reference)
}
\arguments{
\item{model_object}{A superpathway fit model list passed from
\link{singISTrecapitulations}}

\item{data_original}{A matrix with the gene contributions to superpathway's
score as returned by \link{derive_contributions} for the non-singIST treated
samples, passed from \link{singISTrecapitulations}}

\item{data_singIST}{A matrix with the gene contributions to superpathway's
score as returned by \link{derive_contributions} for the singIST treated
samples, passed from \link{singISTrecapitulations}}

\item{cell_reference}{A matrix with the cell type recapitulations as
returned by \link{celltype_recap}}
}
\value{
A \code{data.frame} object with the variables: \code{pathway} name, \code{celltype} name,
\code{gene} name, \code{contribution} gene contribution to cell type recapitulation
}
\description{
Derive gene contribution to cell type recapitulation
}
\examples{
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
model <- example_superpathway_fit_model
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
mapped <- example_mapping_organism
\donttest{
singIST_samples <- biological_link_function(mapped, model)$singIST_samples
original <- derive_contributions(model, singIST_samples)
derived <- derive_contributions(model, model$model_fit$predictor_block)
# Derive cell type reference
cell <- celltype_recap(model, original$celltype_contribution,
derived$celltype_contribution)
# Compute gene contributions
gene_contrib(model, original$gene_contribution, derived$gene_contribution,
cell)}
}
