% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-wrappers.R
\name{multiple_fitOptimal}
\alias{multiple_fitOptimal}
\title{Multiple Cross validation and fit of asmbPLSDA}
\usage{
multiple_fitOptimal(
  object = list(),
  parallel = c(FALSE),
  measure = c("B_accuracy"),
  expected_measure_increase = c(0.005),
  maxiter = c(100),
  global_significance_full = c(FALSE),
  CIP.GIP_significance_full = c(FALSE),
  npermut = c(100),
  nbObsPermut = c(NULL),
  type = c("jackknife"),
  nsubsampling = c(100),
  Method = c(NULL),
  ...
)
}
\arguments{
\item{object}{A list whose elements are superpathway input lists
objects to use \link{fitOptimal}}

\item{parallel}{A vector whose elements are \code{parallel} parameters for each
object as requested by \link{fitOptimal}}

\item{measure}{A vector whose elements are \code{measure} parameters for each
object as requested by \link{fitOptimal}}

\item{expected_measure_increase}{A vector whose elements are
\code{expected_measure_increase} parameters for each object as requested by
\link{fitOptimal}}

\item{maxiter}{A vector whose elements are \code{maxiter} parameters for each
object as requested by \link{fitOptimal}}

\item{global_significance_full}{A vector whose elements are
\code{global_significance_full} parameters for each object as requested by
\link{fitOptimal}}

\item{CIP.GIP_significance_full}{A vector whose elements are
\code{CIP.GIP_significance_full} parameters for each object as requested by
\link{fitOptimal}}

\item{npermut}{A vector whose elements are \code{npermut} parameters for each
object as requested by \link{fitOptimal}}

\item{nbObsPermut}{A vector whose elements are \code{nbObsPermut} parameters for
each object as requested by \link{fitOptimal}}

\item{type}{A vector whose elements are \code{type} parameters for
each object as requested by \link{fitOptimal}}

\item{nsubsampling}{A vector whose elements are \code{nsubsampling} parameters for
each object as requested by \link{fitOptimal}}

\item{Method}{A vector whose elements are \code{Method} parameters for
each object as requested by \link{fitOptimal}}

\item{...}{Other parameters to be passed onto \link{fitOptimal}}
}
\value{
A list of superpathway fit model list
}
\description{
Use \link{fitOptimal} for multiple superpathway input list
objects. This wrapper is useful if one wants to assess multiple superpathways
for analyses and needs to train its respective optimal models.
}
\examples{
\donttest{file <- system.file("extdata", "example_superpathway_input.rda",
package = "singIST")
load(file)
data <- example_superpathway_input
models <- list(data, data)
# Example with different options
multiple_model <- multiple_fitOptimal(models, type = c("jackknife",
"subsampling"), nsubsampling = c(NULL, 10), npermut = c(10,15))}
}
