% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2-biologicalLink.R
\name{orthology_mapping}
\alias{orthology_mapping}
\title{Orthology mapping}
\usage{
orthology_mapping(
  object,
  model_object,
  from_species,
  to_species = "mmusculus",
  annotation_to_species = "external_gene_name"
)
}
\arguments{
\item{object}{A mapping organism list}

\item{model_object}{A superpathway fit model list}

\item{from_species}{A character indicating the reference organism for which
the parameter \code{model_fit} has information from.}

\item{to_species}{A character indicating the mapped organism for which the
parameter \code{object} has information from. By default \code{mmusculus}.}

\item{annotation_to_species}{A character indicating the gene identifier
annotation used for the \code{to_species}. Note this should match with the gene
names in \code{object$counts}. By default \code{external_gene_name}. If \code{NULL}
the \code{annotation_to_species} is inferred with \link{detect_gene_type}, note
this might take time.}
}
\value{
A list with the gene sets per cell type with the one-to-one orthology
}
\description{
Performs the one-to-one orthology mapping between the mapped disease model
list to the reference (human) organism of the superpathway fit model
list.
}
\examples{
\donttest{
# Case without stating the gene annotation of the mapping.organisms object
# note this will take longer to execute
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
data_organism <- example_mapping_organism
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
data_model <- example_superpathway_fit_model
orthology_mapping(data_organism, data_model, "hsapiens",
annotation_to_species = NULL)
# Case assuming the gene annotation of the mapping.organism object is
# by default "external_gene_name" this is faster
orthology_mapping(data_organism, data_model, "hsapiens")}
}
