% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step4-recapitulations.R
\name{singISTrecapitulations}
\alias{singISTrecapitulations}
\title{Compute singIST recapitulations}
\usage{
singISTrecapitulations(object, model_object, ...)
}
\arguments{
\item{object}{A mapping organism list for which to calculate
the recapitulations against the fitted superpathway model}

\item{model_object}{A superpathway fit model list used to
calculate the recapitulations}

\item{...}{Other parameters to pass onto \link{biological_link_function}}
}
\value{
A list with; a \code{data.frame} object with the superpathway recapitulation,
containing variables \code{pathway} name, \code{recapitulation}, \code{p_val} with the
global significance test of the fitted model as provided in \code{model_object},
and \code{target_organism} with the target class of the disease model as provided
in \code{model_object}; a \code{data.frame} with the cell type recapitulation,
containing variables \code{pathway} name, \code{celltype}, \code{recapitulation},
\code{orthology} with the percentage of observed one-to-one orthology coverage
\itemize{
\item if all cell types have the same gene set this value is constant -, and
\code{target_organism}; a \code{data.frame} object with the gene contributions to
cell type recapitulation, containing variables \code{pathway}, \code{celltype},
\code{gene} name, \code{contribution} indicating the gene contribution to cell type
recapitulation, and \code{target_organism}; \code{orthologs} a \code{data.frame} with
the one-to-one orthology mapping for each cell type gene set.
}
}
\description{
This method provides with all singIST recapitulations; superpathway
recapitulations; cell type recapitulations; gene contributions to
cell type recapitulations. The procedure encompasses the execution of the
biological link function, the derivation of the predictor scores
(superpathway, cell type and gene scores), and their use to compute
the predicted recapitulations as a fraction of the reference recapitulation.
}
\examples{
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
data_organism <- example_mapping_organism
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
data_model <- example_superpathway_fit_model
\donttest{singISTrecapitulations(data_organism, data_model)}
}
