% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyMarkerGenesViolin}
\alias{plotScanpyMarkerGenesViolin}
\title{plotScanpyMarkerGenesViolin}
\usage{
plotScanpyMarkerGenesViolin(inSCE, groups = NULL, features = NULL, nGenes = 10)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{groups}{The groups for which to show the gene ranking. Default \code{NULL}
means that all groups will be considered.}

\item{features}{List of genes to plot. Is only useful if interested in a 
custom gene list}

\item{nGenes}{Number of genes to show. Default \code{10}}
}
\value{
plot object
}
\description{
plotScanpyMarkerGenesViolin
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyFindMarkers(sce, colDataName = "Scanpy_louvain_1" )
plotScanpyMarkerGenesViolin(sce, groups = '0')
}
}
