% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNormalization.R
\name{runNormalization}
\alias{runNormalization}
\title{Run normalization/transformation with various methods}
\usage{
runNormalization(
  inSCE,
  useAssay = "counts",
  outAssayName = "logcounts",
  normalizationMethod = "logNormCounts",
  scale = FALSE,
  seuratScaleFactor = 10000,
  transformation = NULL,
  pseudocountsBeforeNorm = NULL,
  pseudocountsBeforeTransform = NULL,
  trim = NULL,
  verbose = TRUE
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{useAssay}{Specify the name of the assay that should be used.}

\item{outAssayName}{Specify the name of the new output assay.}

\item{normalizationMethod}{Specify a normalization method from `LogNormalize`,
`CLR`, `RC` and `SCTransform` from Seurat or `logNormCounts` and `CPM` from
scater packages. Default \code{NULL} is set which will not run any
normalization method.}

\item{scale}{Logical value indicating if the data should be scaled using
Z.Score. Default \code{FALSE}.}

\item{seuratScaleFactor}{Specify the `scaleFactor` argument if a Seurat
normalization method is selected. Default is \code{10000}. This parameter
will not be used if methods other than seurat are selected.}

\item{transformation}{Specify the transformation options to run on the
selected assay. Options include `log2` (base 2 log transformation),
`log1p` (natural log + 1 transformation) and `sqrt` (square root). Default
value is \code{NULL}, which will not run any transformation.}

\item{pseudocountsBeforeNorm}{Specify a numeric pseudo value that should be added
to the assay before normalization is performed. Default is \code{NULL},
which will not add any value.}

\item{pseudocountsBeforeTransform}{Specify a numeric pseudo value that should be
added to the assay before transformation is run. Default is \code{NULL},
which will not add any value.}

\item{trim}{Specify a vector of two numeric values that should be used
as the upper and lower trim values to trim the assay between these two
values. For example, \code{c(10,-10)} will trim the values between 10
and -10. Default is \code{NULL}, which will not trim the data assay.}

\item{verbose}{Logical value indicating if progress messages should be
displayed to the user. Default is \code{TRUE}.}
}
\value{
Output SCE object with new normalized/transformed assay stored.
}
\description{
Wrapper function to run any of the integrated normalization/transformation
methods in the singleCellTK. The available methods include 'LogNormalize',
'CLR', 'RC' and 'SCTransform' from Seurat, 'logNormCounts and 'CPM' from
Scater. Additionally, users can 'scale' using Z.Score, 'transform' using
log, log1p and sqrt, add 'pseudocounts' and trim the final matrices
between a range of values.
}
\examples{
data(sce_chcl, package = "scds")
sce_chcl <- runNormalization(
 inSCE = sce_chcl,
 normalizationMethod = "LogNormalize",
 useAssay = "counts",
 outAssayName = "logcounts")
}
