% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichRSCE.R
\name{getEnrichRResult<-}
\alias{getEnrichRResult<-}
\alias{getEnrichRResult}
\alias{getEnrichRResult,SingleCellExperiment-method}
\alias{getEnrichRResult<-,SingleCellExperiment-method}
\title{Get or Set EnrichR Result}
\usage{
getEnrichRResult(inSCE, analysisName) <- value

getEnrichRResult(inSCE, analysisName)

\S4method{getEnrichRResult}{SingleCellExperiment}(inSCE, analysisName)

\S4method{getEnrichRResult}{SingleCellExperiment}(inSCE, analysisName) <- value
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object.}

\item{analysisName}{A string that identifies each specific analysis}

\item{value}{The EnrichR result table}
}
\value{
For getter method, a data.frame of the EnrichR result;
For setter method, \code{inSCE} with EnrichR results updated.
}
\description{
Get or Set EnrichR Result
}
\examples{
data("mouseBrainSubsetSCE")
if (Biobase::testBioCConnection()) {
  mouseBrainSubsetSCE <- runEnrichR(mouseBrainSubsetSCE, features = c("Vamp7","Cntn2","Olig1"),
                                    db = "GO_Cellular_Component_2025",
                                    analysisName = "analysis1")
  result <- getEnrichRResult(mouseBrainSubsetSCE, "analysis1")
}
}
\seealso{
\code{\link{runEnrichR}}
}
