% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSingleSite.R
\name{plotSingleSite}
\alias{plotSingleSite}
\alias{plotSingleSite.lineagePath}
\alias{plotSingleSite.sitesMinEntropy}
\alias{plotSingleSite.parallelSites}
\alias{plotSingleSite.fixationSites}
\title{Color the tree by a single site}
\usage{
plotSingleSite(x, site, ...)

\method{plotSingleSite}{lineagePath}(x, site, showPath = TRUE, showTips = FALSE, ...)

\method{plotSingleSite}{sitesMinEntropy}(x, site, ...)

\method{plotSingleSite}{parallelSites}(x, site, showPath = TRUE, ...)

\method{plotSingleSite}{fixationSites}(x, site, select = NULL, ...)
}
\arguments{
\item{x}{The object to plot.}

\item{site}{For \code{lineagePath}, it can be any site within sequence
length. For \code{fixationSites} and \code{parallelSites}, it is restrained
to a predicted fixation site. The numbering is consistent with the
reference defined by \code{\link{setSiteNumbering}}.}

\item{...}{Other arguments. Since 1.5.4, the function uses
\code{\link{ggtree}} as the base function to make plots so the arguments in
\code{plot.phylo} will no longer work.}

\item{showPath}{If plot the lineage result from \code{\link{lineagePath}}.
The default is \code{TRUE}.}

\item{showTips}{Whether to plot the tip labels. The default is \code{FALSE}.}

\item{select}{Select which fixation path in to plot. The default is NULL
which will plot all the fixations.}
}
\value{
Since 1.5.4, the function returns a ggplot object so on longer
  behaviors like the generic \code{\link{plot}} function.
}
\description{
Plot and color the tree according to amino acid/nucleotide of
  the selected site. The color scheme depends on the \code{seqType} set in
  \code{\link{addMSA}} function.

For \code{\link{lineagePath}}, the tree will be colored
  according to the amino acid of the site. The color scheme tries to assign
  distinguishable color for each amino acid.

For \code{\link{parallelSites}}, the tree will be colored
  according to the amino acid of the site if the mutation is not fixed.

For \code{\link{fixationSites}}, it will color the ancestral
  tips in red, descendant tips in blue and excluded tips in grey.
}
\examples{
data(zikv_tree)
data(zikv_align)
tree <- addMSA(zikv_tree, alignment = zikv_align)
paths <- lineagePath(tree)
plotSingleSite(paths, 139)
fixations <- fixationSites(paths)
plotSingleSite(fixations, 139)
}
\seealso{
\code{\link{plot.sitePath}}
}
