% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlalomModel-methods.R
\name{topTerms}
\alias{topTerms}
\title{Show results of a Slalom model}
\usage{
topTerms(object, n_active = 20, mad_filter = 0.4, annotated = TRUE,
  unannotated_dense = FALSE, unannotated_sparse = FALSE)
}
\arguments{
\item{object}{an object of class \code{Rcpp_SlalomModel}}

\item{n_active}{number of terms (factors) to be plotted (default is 20)}

\item{mad_filter}{numeric(1), filter factors by this mean absolute deviation
to exclude outliers. For large datasets this can be set to 0}

\item{annotated}{logical(1), should annotated factors be plotted? Default is
\code{TRUE}}

\item{unannotated_dense}{logical(1), should dense unannotated factors be
plotted? Default is \code{FALSE}}

\item{unannotated_sparse}{logical(1), should sparse unannotated factors be
plotted? Default is \code{FALSE}}
}
\value{
data.frame with factors ordered by relevance, showing \code{term}
(term names), \code{relevance}, \code{type} (factor type: known, annotated
or unannotated), \code{n_prior} (number of genes annotated to the gene
set/factor), \code{n_gain} (number of genes added/switched on for the
factor), \code{n_loss} (number of genes turned off for the factor).
}
\description{
Show results of a Slalom model
}
\examples{
gmtfile <- system.file("extdata", "reactome_subset.gmt", package = "slalom")
genesets <- GSEABase::getGmt(gmtfile)
data("mesc")
model <- newSlalomModel(mesc, genesets, n_hidden = 5, min_genes = 10)
model <- initSlalom(model)
model <- trainSlalom(model, nIterations = 10)
topTerms(model)
}
