% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildDataFrame.R
\name{buildDataFrame}
\alias{buildDataFrame}
\title{Extract a data frame for a certain gene and PI from a fitted object}
\usage{
buildDataFrame(
  obj,
  gene,
  pi = c("nn", "nnPair", "edge", "centroid", "nnCell", "nnPairCell"),
  piMat,
  pppDf,
  prepMat,
  prepTab,
  prepCells
)
}
\arguments{
\item{obj}{A results object. For distances to fixed objects, the result of a call to \link{estPis};
for nearest neighbour distances, the result of a call to \link{addWeightFunction}}

\item{gene}{A character string indicating the desired gene or gene pair (genes separated by double hyphens)}

\item{pi}{character string indicating the desired PI}

\item{piMat}{A data frame. Will be constructed if not provided, for internal use.}

\item{pppDf}{Dataframe of point pattern-wise variables. It is precalculated
in fitLMMsSingle for speed, but will be newly constructed when not provided.}

\item{prepMat, prepTab, prepCells}{Preconstructed objects to save computation time, for internal use}
}
\value{
A dataframe with estimated PIs and covariates
}
\description{
Based on a fitted object, a dataframe with results for a certain feature and
 PI is built, e.g. in preparation for linear modelling.
}
\examples{
example(addWeightFunction, "smoppix")
dfUniNN <- buildDataFrame(yangObj, gene = "SmVND2", pi = "nn")
# Example analysis with linear mixed model
library(lmerTest)
mixedMod <- lmer(pi - 0.5 ~ day + (1 | root), weight = weight, data = dfUniNN,
    contrasts = list("day" = "contr.sum")
)
summary(mixedMod)
# Evidence for aggregation
}
\seealso{
\link{addWeightFunction}
}
