% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_builder_wrappers.R
\name{get_column_filters}
\alias{get_column_filters}
\alias{set_column_filters}
\title{Get or set sample-related contraints for query}
\usage{
get_column_filters(qb)

set_column_filters(qb, ...)
}
\arguments{
\item{qb}{a QueryBuilder object constructed using the
\code{\link{QueryBuilder}} function}

\item{...}{one or more boolean predicates as either strings or unevaluated
expressions}
}
\value{
\code{get_column_filters} returns the current filters as a list of strings.
\code{set_column_filters} returns a new \code{QueryBuilder} object
with the column filters set to the value of \code{column_filters}.
}
\description{
Get or set sample-related contraints for query
}
\examples{
qb <- QueryBuilder(compilation = "gtex", regions = "CD99")
# column filters set using a string
qb <- set_column_filters(qb, "SMTS == Brain")
get_column_filters(qb)
# column filters set using unevaluated expression
qb <- set_column_filters(qb, SMTS == "Spleen")
get_column_filters(qb)
}
