% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_builder_wrappers.R
\name{get_sids}
\alias{get_sids}
\alias{set_sids}
\title{Get or set query sample ids}
\usage{
get_sids(qb)

set_sids(qb, sids)
}
\arguments{
\item{qb}{a QueryBuilder object constructed using the
\code{\link{QueryBuilder}} function.}

\item{sids}{a vector or 1 or more whole numbers to filter results on.}
}
\value{
\code{get_sids} returns the current sample ids as a vector of integers.
\code{set_sids} returns a new \code{QueryBuilder} object with the
sample ids set to the value of \code{sids}.
}
\description{
Get or set query sample ids
}
\examples{
qb <- QueryBuilder(compilation = "gtex", regions = "CD99")
qb <- set_sids(qb, c(1, 2, 3))
get_sids(qb)
}
