% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_level_functions.R
\name{junction_union}
\alias{junction_union}
\title{Get the union of junctions from 2 or more compilations
which are on the same reference}
\usage{
junction_union(...)
}
\arguments{
\item{...}{One or more QueryBuilder objects}
}
\value{
A RangedSummarizedExperiment of junctions appearing in at least
one compilation
}
\description{
This function queries 2 or more compilations which are on the same
reference version (e.g. hg38) and merges the resulting junctions
into a single output table, unioning the sample coverage columns
and the snaptron_id (jx ID) columns (the latter delimiter will
be ":").  All sample IDs will be disjoint between compilations.
}
\details{
Union is based on the following fields (combined into a comparison key):
\itemize{
\item group
\item chromosome
\item start
\item end
\item strand
}

The goal is to have a single list of junctions where every junction
occurs in at least one compilation and if a junction occurs in > 1
compilations it still only has a single row representing all the
samples across compilations that it appears in.
Sample aggregate statistics will be recalculated for junctions which
are merged across \emph{all} samples from all compilations:

\itemize{
\item sample_count
\item coverage_sum
\item coverage_avg
\item coverage_median
}
}
\examples{
# Using query builder wrappers
sb1 <- QueryBuilder(compilation = "gtex", regions = "chr1:1879786-1879786")
sb1 <- set_coordinate_modifier(sb1, Coordinates$EndIsExactOrWithin)
sb1 <- set_row_filters(sb1, strand == "-")

sb2 <- QueryBuilder(compilation = "tcga", regions = "chr1:1879786-1879786")
sb2 <- set_coordinate_modifier(sb2, Coordinates$EndIsExactOrWithin)
sb2 <- set_row_filters(sb2, strand == "-")

junction_union(sb1, sb2)
}
\seealso{
\code{\link[=junction_intersection]{junction_intersection()}}
}
